/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report;

import com.google.common.collect.Lists;
import cz.insophy.inplan.util.CalendarHelper;
import cz.insophy.inplan.util.Localizer;
import cz.insophy.inplan.util.TimeSpan;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public enum TimeFrame {
    THIS_WEEK(Localizer.getString("report.timeframe_this_week")),
    NEXT_WEEK(Localizer.getString("report.timeframe_next_week")),
    THIS_MONTH(Localizer.getString("report.timeframe_this_month")),
    NEXT_MONTH(Localizer.getString("report.timeframe_next_month")),
    THIS_YEAR(Localizer.getString("report.timeframe_this_year")),
    NEXT_YEAR(Localizer.getString("report.timeframe_next_year"));

    private final String title;

    private TimeFrame(String pTitle) {
        this.title = pTitle;
    }

    public String toString() {
        return this.title;
    }

    public TimeSpan getInterval(long startDate) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(startDate);
        return TimeSpan.fromStartEnd(startDate, switch (this) {
            case THIS_WEEK -> CalendarHelper.setWeekEnd(c).getTimeInMillis();
            case THIS_MONTH -> CalendarHelper.setMonthEnd(c).getTimeInMillis();
            case THIS_YEAR -> CalendarHelper.setYearEnd(c).getTimeInMillis();
            case NEXT_WEEK -> {
                CalendarHelper.setWeekStart(c);
                c.add(5, 14);
                yield c.getTimeInMillis() - 1L;
            }
            case NEXT_MONTH -> {
                CalendarHelper.setMonthStart(c);
                c.add(2, 2);
                yield c.getTimeInMillis() - 1L;
            }
            case NEXT_YEAR -> {
                CalendarHelper.setYearStart(c);
                c.add(1, 2);
                yield c.getTimeInMillis() - 1L;
            }
            default -> throw new IllegalStateException();
        });
    }

    public TimeSpan getInterval() {
        Calendar c = Calendar.getInstance();
        CalendarHelper.setDayStart(c);
        long startDate = c.getTimeInMillis();
        return this.getInterval(startDate);
    }

    public List<TimeSpan> getSubIntervals(boolean addPrePost, long startDate) {
        TimeSpan interval = this.getInterval(startDate);
        return TimeFrame.computeSubIntervals(addPrePost, interval);
    }

    public List<TimeSpan> getSubIntervals(boolean addPrePost) {
        TimeSpan interval = this.getInterval();
        return TimeFrame.computeSubIntervals(addPrePost, interval);
    }

    private static List<TimeSpan> computeSubIntervals(boolean addPrePost, TimeSpan interval) {
        long tempEndDate;
        long startDate = interval.getStart();
        long endDate = interval.getEnd();
        int tfUnit = TimeFrame.fitLargestUnit(startDate, endDate);
        LinkedList<TimeSpan> result = Lists.newLinkedList();
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(startDate);
        long firstStartDate = -1L;
        long lastEndDate = -1L;
        do {
            long tempStartDate = c.getTimeInMillis();
            c.add(tfUnit, 1);
            tempEndDate = Math.min(endDate, c.getTimeInMillis() - 1L);
            result.add(TimeSpan.fromStartEnd(tempStartDate, tempEndDate));
            if (firstStartDate < 0L) {
                firstStartDate = tempStartDate;
            }
            lastEndDate = tempEndDate;
        } while (tempEndDate < endDate);
        if (addPrePost && firstStartDate != -1L && lastEndDate != -1L) {
            result.add(0, TimeSpan.fromStartEnd(Long.MIN_VALUE, firstStartDate - 1L));
            result.add(TimeSpan.fromStartEnd(lastEndDate + 1L, Long.MAX_VALUE));
        }
        return Collections.unmodifiableList(result);
    }

    private static int fitLargestUnit(long startTime, long endTime) {
        if (CalendarHelper.howManyFitsBetween(2, startTime, endTime) > 1) {
            return 2;
        }
        if (CalendarHelper.howManyFitsBetween(3, startTime, endTime) > 1) {
            return 3;
        }
        return 5;
    }
}

